<?php
/***************************************************************
*  Copyright notice
*
*  (c) 2006 Michael Fritz <michael.fritz@target-e.de>
*  All rights reserved
*
*  This script is part of the TYPO3 project. The TYPO3 project is
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
*
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/
/**
 * Plugin 'WorldCup Bets' for the 'worldcup' extension.
 *
 * @author	Michael Fritz <michael.fritz@target-e.de>
 * @package TYPO3
 * @subpackage worldcup
 */
/**
 * [CLASS/FUNCTION INDEX of SCRIPT]
 *
 *
 *
 *   61: class tx_worldcup_pi1 extends tslib_pibase
 *   67:     function main($content='',$conf=array())
 *  106:     function contentSwitch()
 *  149:     function menu()
 *  162:     function graphicalOverview()
 *  224:     function listGroups ()
 *  254:     function listTable ($group)
 *  287:     function calculateTable (&$res)
 *  383:     function displayFullTable ($teams=array())
 *  418:     function displayTable ($teams=array())
 *  438:     function listGames($group)
 *  549:     function theWinnerIs ($team1,$team2)
 *  561:     function savebet ()
 *  619:     function mayBetOnGame($uid)
 *  641:     function ranking()
 *  707:     function howUserRanked ($group,$userfilter='')
 *
 * TOTAL FUNCTIONS: 15
 * (This index is automatically created/updated by the extension "extdeveval")
 *
 */


require_once(PATH_tslib.'class.tslib_pibase.php');
require_once(t3lib_extMgm::extPath('worldcup').'pi1/class.tx_worldcup_arraysorter.php');


class tx_worldcup_pi1 extends tslib_pibase {
	var $prefixId = 'tx_worldcup_pi1';		// Same as class name
	var $scriptRelPath = 'pi1/class.tx_worldcup_pi1.php';	// Path to this script relative to the extension dir.
	var $extKey = 'worldcup';	// The extension key.
	var $pi_checkCHash = false;

	function main($content='',$conf=array()) {
		$this->pi_loadLL();
		$this->resources = t3lib_extMgm::siteRelPath('worldcup').'res/';

		$this->loggedIn = strlen(trim($GLOBALS["TSFE"]->fe_user->user['uid']))>0;

		//default
		$this->pointsfordifference = false;
		$this->strorage_pid = 1;
		$this->linktofifa = true;

		$confArr = unserialize($GLOBALS['TYPO3_CONF_VARS']['EXT']['extConf']['worldcup']);
		$this->linktofifa = $confArr['linktofifa'];
		$this->strorage_pid = $confArr['storage_pid'];
		$this->pointsfordifference = $confArr['pointsfordifference'];

		$this->playlist = array(
									'A' => $this->pi_getLL('playgroup').' A',
									'B' => $this->pi_getLL('playgroup').' B',
									'C' => $this->pi_getLL('playgroup').' C',
									'D' => $this->pi_getLL('playgroup').' D',
									'E' => $this->pi_getLL('playgroup').' E',
									'F' => $this->pi_getLL('playgroup').' F',
									'G' => $this->pi_getLL('playgroup').' G',
									'H' => $this->pi_getLL('playgroup').' H',
									'I' => $this->pi_getLL('playgroup').' I',

									'16' => $this->pi_getLL('round of 16'),
									'8' => $this->pi_getLL('quarter-finals'),
									'4' => $this->pi_getLL('semi-finals'),
									'3' => $this->pi_getLL('thirdplace'),
									'2' => $this->pi_getLL('finals'),

								);

		$content .= '<div class="'.$this->pi_getClassName($prefixId.'menu').'"><a name="tx_worldcup_top"></a>'
						.$this->menu().
					'</div>';
		$content .= '<div class="'.$this->pi_getClassName($prefixId.'content').'">'
						.$this->contentSwitch().
					'</div>';

		#print '<div style="position:absolute;left:1000px"><pre>';
		#print_r();
		#print '</pre></div>';


		return $this->pi_wrapInBaseClass($content);
	}

	/**
	 * Chooses content
	 *
	 * @return	string		output to website
	 */
	function contentSwitch() {
		switch (t3lib_div::_GET('mode')) {
			case '':
			case 'listGroups':
				t3lib_div::_GETset(array('mode' => 'listGroups'));
				$content .= $this->listGroups();
				break;
			case 'groupdetail':
				$content .= '<h1>'.$this->pi_getLL('ranking').'</h1>';
				$content .= $this->displayFullTable($this->calculateTable($this->listTable(t3lib_div::_GET('group'))));

				$content .= '<h1>'.$this->pi_getLL('games').'</h1>';
				$content .= $this->listGames(t3lib_div::_GET('group'));

				$content .= '<h1>'.$this->pi_getLL('howuserbets').'</h1>';
				$content .= $this->howUserRanked(t3lib_div::_GET('group'));

				if ($this->loggedIn) {
					$content .= '<h1>'.$this->pi_getLL('mytable').'</h1>';
					$content .= $this->howUserRanked(t3lib_div::_GET('group'),$GLOBALS["TSFE"]->fe_user->user['uid']);
				}

				$content .= '<a href="'.$this->pi_getPageLink($GLOBALS["TSFE"]->id,'',array()).'#group'.t3lib_div::_GET('group').'">'.$this->pi_getLL('back').'</a>';

				break;
			case 'savebet':
				$content .= $this->savebet();
				break;
			case 'ranking':
				$content .= $this->ranking();
				break;
			case 'graphicalOverview':
				$content .= $this->graphicalOverview();
				break;
		}
		return $content;
	}

	/**
	 * creates the menu
	 *
	 * @return	string		output to the website
	 */
	function menu() {
		$content .= '<a href="'.$this->pi_getPageLink($GLOBALS["TSFE"]->id,$target='',array('mode'=>'listGroups')).'#tx_worldcup_top">'.$this->pi_getLL('games').'</a>';
		$content .= '&nbsp;<a href="'.$this->pi_getPageLink($GLOBALS["TSFE"]->id,$target='',array('mode'=>'ranking')).'#tx_worldcup_top">'.$this->pi_getLL('ranking').'</a>';
		#$content .= '&nbsp;<a href="'.$this->pi_getPageLink($GLOBALS["TSFE"]->id,$target='',array('mode'=>'graphicalOverview')).'#tx_worldcup_top">'.$this->pi_getLL('graphicalOverview').'</a>';

		return $content;
	}

	/**
	 * graphical overview of the finals
	 *
	 * @return	string		output to the website
	 */
	function graphicalOverview() {
		$td = array();
		foreach($this->playlist as $key => $value){
			if (!is_numeric($key)) {
				$td['group'][$key] .= $this->displayTable($this->calculateTable($this->listTable($key)));
				$group[$key] = $this->temp_succeed;
			}
		}

		$content .= '<table border="1">
							<tr>
								<td></td>
								<td>16</td>
								<td>8</td>
								<td>4</td>
								<td>2</td>
							<tr>
								<td>'.$td['group']['A'].'</td>
								<td rowspan="2" valign="middle">'.$group['A'][0].':'.$group['B'][1].'<br /><br /><br /><br />'.$group['B'][0].':'.$group['A'][1].'</td>
								<td rowspan="4" valign="middle"></td>
								<td rowspan="8" valign="middle"></td>
								<td rowspan="8" valign="middle"></td>
							</tr>
							<tr>
								<td valign="middle">'.$td['group']['B'].'</td>
							</tr>
							<tr>
								<td valign="middle">'.$td['group']['C'].'</td>
								<td rowspan="2" valign="middle">'.$group['C'][0].':'.$group['D'][1].'<br /><br /><br /><br />'.$group['D'][0].':'.$group['C'][1].'</td>
							</tr>
							<tr>
								<td valign="middle">'.$td['group']['D'].'</td>
							</tr>
							<tr>
								<td valign="middle">'.$td['group']['E'].'</td>
								<td rowspan="2" valign="middle">'.$group['E'][0].':'.$group['F'][1].'<br /><br /><br /><br />'.$group['F'][0].':'.$group['E'][1].'</td>
								<td valign="middle" rowspan="4"></td>
							</tr>
							<tr>
								<td valign="middle">'.$td['group']['F'].'</td>
							</tr>
							<tr>
								<td valign="middle">'.$td['group']['G'].'</td>
								<td rowspan="2" valign="middle">'.$group['G'][0].':'.$group['H'][1].'<br /><br /><br /><br />'.$group['H'][0].':'.$group['G'][1].'</td>
							</tr>
							<tr>
								<td valign="middle">'.$td['group']['H'].'</td>
							</tr>
					</table>';
		return $content;
	}

	/**
	 * list all groups and the games
	 *
	 * @return	string		output to the website
	 */
	function listGroups () {
		$sql = "SELECT	g.finals AS keychar,
						count(uid) AS gamecount

			FROM		tx_worldcup_games g
			WHERE		g.deleted = 0
			GROUP BY	g.finals
			ORDER BY	g.finals ASC";
		$res=$GLOBALS['TYPO3_DB']->sql_query($sql) OR DIE(mysql_error());

		while ($r = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res)) {
			$content .= '<a name="group'.$r['keychar'].'"></a><h1>'.$this->playlist[$r['keychar']].' ('.$r['gamecount'].' '.$this->pi_getLL('games').')</h1>';
			$content .= $this->listGames($r['keychar']);

			if (!is_numeric($r['keychar'])) {
				//display only, if group is no final
				$urlParameters['mode'] = 'groupdetail';
				$urlParameters['group'] = $r['keychar'];
				$content .= '<a href="'.$this->pi_getPageLink($GLOBALS["TSFE"]->id,$target='',$urlParameters).'#tx_worldcup_top">'.$this->pi_getLL('more...').'</a>';
			}
		}
		return $content;
	}

	/**
	 * [Describe function...]
	 *
	 * @param	integer		$group: keychar wich group is meant now
	 * @return	record		the query to render
	 */
	function listTable ($group) {
		$sql = "SELECT	g.uid,
						g.playtime,
						g.team1 AS team1_uid,
						g.team2 AS team2_uid,
						g.goals_team1,
						g.goals_team2,
						g.place,
						g.finals,

						t1.name AS team1,
						t2.name AS team2,
						UPPER(t1.shortcut) AS shortcut1,
						UPPER(t2.shortcut) AS shortcut2

			FROM		(tx_worldcup_games g INNER JOIN  tx_worldcup_teams t1
			ON			g.team1 = t1.uid) INNER JOIN tx_worldcup_teams t2
			ON			g.team2 = t2.uid
			WHERE		g.deleted = 0
			AND			t1.deleted = 0
			AND			t2.deleted = 0
			AND			g.finals = '".$GLOBALS['TYPO3_DB']->quoteStr($group,'tx_worldcup_games')."'";
		$res=$GLOBALS['TYPO3_DB']->sql_query($sql) OR DIE(mysql_error());

		return $res;
	}

	/**
	 * calculate the standings / rankings
	 *
	 * @param	record		$$res: the query to be rendered
	 * @return	array		an array of the standings
	 */
	function calculateTable (&$res){
		$teams = array();
		$array_sorter = t3lib_div::makeInstance("tx_worldcup_arraysorter");

		$i = 0;
		while ($r = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res)) {
			if (!array_key_exists($r['team1_uid'],$teams)) {
				$i++;
				$teams[$r['team1_uid']] = array();
				$teams[$r['team1_uid']]['name'] = $r['team1'];
				$teams[$r['team1_uid']]['uid'] = $r['team1_uid'];
				$teams[$r['team1_uid']]['shortcut'] = $r['shortcut1'];
				$teams[$r['team1_uid']]['points'] = 0;
				$teams[$r['team1_uid']]['plusgoals'] = 0;
				$teams[$r['team1_uid']]['minusgoals'] = 0;
				$teams[$r['team1_uid']]['games'] = 0;
				$teams[$r['team1_uid']]['pos'] = $i;
				$teams[$r['team1_uid']]['winagainst'] = array();
			}
			if (!array_key_exists($r['team2_uid'],$teams)) {
				$i++;
				$teams[$r['team2_uid']] = array();
				$teams[$r['team2_uid']]['name'] = $r['team2'];
				$teams[$r['team2_uid']]['uid'] = $r['team2_uid'];
				$teams[$r['team2_uid']]['shortcut'] = $r['shortcut2'];
				$teams[$r['team2_uid']]['points'] = 0;
				$teams[$r['team2_uid']]['plusgoals'] = 0;
				$teams[$r['team2_uid']]['minusgoals'] = 0;
				$teams[$r['team2_uid']]['games'] = 0;
				$teams[$r['team2_uid']]['pos'] = $i;
				$teams[$r['team2_uid']]['winagainst'] = array();
			}

			if (strlen($r['goals_team1'])>0 && strlen($r['goals_team2'])>0) {
				$teams[$r['team1_uid']]['games']++;
				$teams[$r['team2_uid']]['games']++;

				$teams[$r['team1_uid']]['plusgoals'] += $r['goals_team1'];
				$teams[$r['team1_uid']]['minusgoals'] += $r['goals_team2'];

				$teams[$r['team2_uid']]['plusgoals'] += $r['goals_team2'];
				$teams[$r['team2_uid']]['minusgoals'] += $r['goals_team1'];

				if ((int)$r['goals_team2'] < (int)$r['goals_team1']) {
					$teams[$r['team1_uid']]['points'] += 3;
					$teams[$r['team1_uid']]['winagainst'][$r['team2_uid']] = true;
				}
				else if ((int)$r['goals_team2'] > (int)$r['goals_team1']) {
					$teams[$r['team2_uid']]['points'] += 3;
					$teams[$r['team2_uid']]['winagainst'][$r['team1_uid']] = true;
				}
				else {
					$teams[$r['team1_uid']]['points']++;
					$teams[$r['team2_uid']]['points']++;
				}
			}
		}

		foreach ($teams as $key) {
			if ($teams[$key['uid']]['games'] > 3) {
				$teams[$key['uid']]['plusgoals'] = round(($teams[$key['uid']]['plusgoals']/$teams[$key['uid']]['games'])*30)/10;
				$teams[$key['uid']]['minusgoals'] = round(($teams[$key['uid']]['minusgoals']/$teams[$key['uid']]['games'])*30)/10;
				$teams[$key['uid']]['points'] = round(($teams[$key['uid']]['points']/$teams[$key['uid']]['games'])*30)/10;
				$teams[$key['uid']]['games'] = 3;
			}
		}

		for($i=0;$i<4; $i++) {
			foreach ($teams as $key) {
			 	foreach ($teams as $key2) {
					if ($key['points'] > $key2['points'] && $key['pos'] > $key2['pos']) {
						//wenn manschaft 1 mehr punkte als manschaft 2: pl?tze tauschen
						$pos1 = $teams[$key['uid']]['pos'];
						$pos2 = $teams[$key2['uid']]['pos'];

						$teams[$key['uid']]['pos'] = $pos2;
						$teams[$key2['uid']]['pos'] = $pos1;
					}
					else if (
						/*punktverh?ltnis gleich*/
						$key['points'] == $key2['points'] &&
						$key['pos'] < $key2['pos'] && (
							/*und schlechteres torverh?ltnis*/
							$teams[$key['uid']]['plusgoals']-$teams[$key['uid']]['minusgoals'] < $teams[$key2['uid']]['plusgoals']-$teams[$key2['uid']]['minusgoals'] || (
								/*oder gleiches torverh?ltnis und weniger tore geschossen*/
								$teams[$key['uid']]['plusgoals']-$teams[$key['uid']]['minusgoals'] === $teams[$key2['uid']]['plusgoals']-$teams[$key2['uid']]['minusgoals'] &&
								$teams[$key['uid']]['plusgoals'] < $teams[$key2['uid']]['plusgoals']))) {
						//ist im torverh?ltnis bessers
						$pos1 = $teams[$key['uid']]['pos'];
						$pos2 = $teams[$key2['uid']]['pos'];

						$teams[$key['uid']]['pos'] = $pos2;
						$teams[$key2['uid']]['pos'] = $pos1;
					}
				}
			}
		}

		$array_sorter->array_sorter(&$teams,'pos',true);
		$teams = $array_sorter->sortit();

		return $teams;
	}

	/**
	 * display the standings
	 *
	 * @param	array		$teams: the array rendered the standings
	 * @return	string		output to website
	 */
	function displayFullTable ($teams=array()) {
		$content .= '<table>
						<tr>
							<td><strong>'.$this->pi_getLL('position').'</strong></td>
							<td><strong>'.$this->pi_getLL('games').'</strong></td>
							<td><strong>'.$this->pi_getLL('team').'</strong></td>
							<td><strong>'.$this->pi_getLL('points').'</strong></td>
							<td><strong>'.$this->pi_getLL('goals').'</strong></td>
						</tr>';

		$i = 1;
		foreach ($teams as $key => $row) {
			$content .= '
						<tr>
							<td align="center">'.$row['pos'].'</td>
							<td align="center">'.$row['games'].'</td>
							<td>'.($row['pos']<=2?'<strong>':'').'<img src="'.$this->resources.$row['shortcut'].'.gif"  alt="'.$row['name'].'" /> '.$row['name'].($row['pos']<=2?'</strong>':'').'</td>
							<td align="center">'.$row['points'].'</td>
							<td>'.$row['plusgoals'].':'.$row['minusgoals'].'</td>
						</tr>';
			$i++;
		}
		$content .= '</table><br /><br />';

		unset($teams);

		return $content;
	}

	/**
	 * display a table without names
	 *
	 * @param	array		$teams: the stanings
	 * @return	string		output to website, mind there is a this variable which is not returned, but needed in a different method, not clean programming, but works :-)
	 */
	function displayTable ($teams=array()) {
		$i = 1;
		$this->temp_succeed = array();
		foreach ($teams as $key => $row) {
			if ($row['pos']<=2) $this->temp_succeed[] .= '<img src="'.$this->resources.$row['shortcut'].'.gif"  alt="'.$row['name'].'" />';
			$content .= '<img src="'.$this->resources.$row['shortcut'].'.gif"  alt="'.$row['name'].'" /><br />';
			$i++;
		}

		unset($teams);

		return $content;
	}

	/**
	 * list the games to bet on
	 *
	 * @param	integer		$group: the group to display
	 * @return	string		output to the website
	 */
	function listGames($group) {
		$sql = "SELECT	g.uid,
						g.playtime,
						g.team1 AS team1_uid,
						g.team2 AS team2_uid,
						CONCAT(g.goals_team1,':',g.goals_team2) AS result,
						g.place,
						g.finals,
						g.goals_team1,
						g.goals_team2,

						t1.name AS team1,
						t2.name AS team2,
						UPPER(t1.shortcut) AS shortcut1,
						UPPER(t2.shortcut) AS shortcut2,

						b.goals_team2 AS bgoals_team2,
						b.goals_team1 AS bgoals_team1

			FROM		((tx_worldcup_games g INNER JOIN  tx_worldcup_teams t1
			ON			g.team1 = t1.uid) INNER JOIN tx_worldcup_teams t2
			ON			g.team2 = t2.uid) LEFT OUTER JOIN tx_worldcup_bets b
			ON			b.game = g.uid
			AND			b.deleted = 0
			AND			b.fe_user_id = '".($this->loggedIn?$GLOBALS["TSFE"]->fe_user->user['uid']:0)."'

			WHERE		g.deleted = 0
			AND			t1.deleted = 0
			AND			t2.deleted = 0
			".(strlen($group)>0?"AND g.finals = '".$GLOBALS['TYPO3_DB']->quoteStr($group,'tx_worldcup_games')."'":'')."
			ORDER BY	g.finals DESC,
						g.playtime ASC
			";
		$res=$GLOBALS['TYPO3_DB']->sql_query($sql) OR DIE(mysql_error());

		$urlParameters['mode'] = 'savebet';
		$content .= '<form name="betform" action="'.$this->pi_getPageLink($GLOBALS["TSFE"]->id,$target='',$urlParameters).'#tx_worldcup_top" method="post">';
		$content .= '<input type="hidden" name="backmode" value="'.t3lib_div::_GET('mode').'" />';
		$content .= '<input type="hidden" name="backgroup" value="'.t3lib_div::_GET('group').'" />';

		$content .= '<table width="100%">
						<tr>
							<td><strong>'.$this->pi_getLL('time').'</strong></td>
							<td><strong>'.$this->pi_getLL('placetoplay').'</strong></td>
							<td align="right"><strong>'.$this->pi_getLL('team1').'</strong></td>
							<td>&nbsp;</td>
							<td><strong>'.$this->pi_getLL('team2').'</strong></td>
							<td><strong>'.$this->pi_getLL('result').'</strong></td>
							'.($this->loggedIn?'<td nowrap="nowrap"><strong>'.$this->pi_getLL('mybet').'</strong></td>':'').'
						</tr>';
		$needBetButton = false;
		while ($r = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res)) {
			$content .= '<tr>
								<td nowrap="nowrap">'.date($this->pi_getLL("formating"),$r['playtime']).'</td>
								<td nowrap="nowrap">'.$r['place'].'</td>
								<td nowrap="nowrap" align="right">'.($this->linktofifa==1?'<a href="http://fifaworldcup.yahoo.com/06/'.$this->pi_getLL("fifalanglable").'/t/team/overview.html?team='.$r['shortcut1'].'">':'').$r['team1'].($this->linktofifa==1?'</a>':'').' <img src="'.$this->resources.$r['shortcut1'].'.gif"  alt="'.$r['team1'].'" /></td>
								<td align="center">:</td>
								<td nowrap="nowrap"><img src="'.$this->resources.$r['shortcut2'].'.gif"  alt="'.$r['team2'].'" /> '.($this->linktofifa==1?'<a href="http://fifaworldcup.yahoo.com/06/'.$this->pi_getLL("fifalanglable").'/t/team/overview.html?team='.$r['shortcut2'].'">':'').$r['team2'].($this->linktofifa==1?'</a>':'').'</td>
								<td nowrap="nowrap" align="center">'.($r['result']!=':'?$r['result']:'-:-').'</td>';
			if ($this->loggedIn) {
				$content .= '<td nowrap="nowrap" align="center">';
				if ($r['playtime'] > time()) {
					$content .= '<input type="text" name="bet['.$r['uid'].'][1]" value="'.$r['bgoals_team1'].'" size="2" maxlength="2" />:<input type="text" name="bet['.$r['uid'].'][2]" value="'.$r['bgoals_team2'].'" size="2" maxlength="2" />';
					$needBetButton = true;
				}
				else {
					$style = '';
					$comment = '';
					if (is_numeric($r['goals_team1']) && is_numeric($r['goals_team2']) && is_numeric($r['bgoals_team1']) && is_numeric($r['bgoals_team2'])) {
						$winner = $this->theWinnerIs($r['goals_team1'],$r['goals_team2']);
						$tipped = $this->theWinnerIs($r['bgoals_team1'],$r['bgoals_team2']);

						if ($winner === $tipped) {
							//richtiges ergebnis
							$style .= 'color:green;';
							$comment = $this->pi_getLL("wonbytendency");
							if ( $r['bgoals_team1'].':'.$r['bgoals_team2'] == $r['goals_team1'].':'.$r['goals_team2']) {
								$style .= 'font-weight:bold;';
								$comment = $this->pi_getLL("wonexactely");
							}
							else if ($this->pointsfordifference && $r['bgoals_team1']-$r['bgoals_team2'] == $r['goals_team1']-$r['goals_team2']) {
								$style .= 'font-style:italic;';
								$comment = $this->pi_getLL("wonbydifference");
							}
						}
						else {
							$style .= 'text-decoration:line-through;';
							$comment = $this->pi_getLL("loose");
						}
					}
					$content .= '<span style="'.$style.'" title="'.$comment.'">'.$r['bgoals_team1'].':'.$r['bgoals_team2'].'</span>';
				}
				$content .= '</td>';
			}
			$content .= '</tr>';
		}

		if ($this->loggedIn && $needBetButton) {
			$content .= '<tr>
							<td colspan="6">&nbsp;</td>
							<td><input type="submit" value="'.$this->pi_getLL('save').'" /></td>
						</tr>';
		}
		$content .= '</table></form>';

		return $content;
	}

	/**
	 * whichone of the teams is the winner? input: gloals - output winner
	 *
	 * @param	integer		$team1: goals of team 1
	 * @param	[type]		$team2: goals of team 2
	 * @return	integer		0= tied, 1=team1...
	 */
	function theWinnerIs ($team1,$team2) {
		if ($team1 > $team2) return 1;
		if ($team1 < $team2) return 2;

		return 0;
	}

	/**
	 * save bets fired up from the form via t3lib_div::_POST('bet')
	 *
	 * @return	string		output to the website
	 */
	function savebet () {

		$i = array();
		$o = array();
		foreach(t3lib_div::_POST('bet') as $key => $value) {
			if(is_numeric($value[1]) && is_numeric($value[2])) {
				$team1 = (int) $value[1];
				$team2 = (int) $value[2];
				$uid = $key;

				if ($this->mayBetOnGame($uid)) {
					$sql = "INSERT INTO tx_worldcup_bets (
									pid,
									crdate,
									cruser_id,
									game,
									fe_user_id
								)  VALUES (
									'".$this->strorage_pid."',
									'".time()."',
									'1',
									'".intval($uid)."',
									'".intval($GLOBALS["TSFE"]->fe_user->user['uid'])."'
								)";
					$insert_try=$GLOBALS['TYPO3_DB']->sql_query($sql);

					$sql = "UPDATE	tx_worldcup_bets
							SET		tstamp = ".time().",
									deleted = 0,
									goals_team1 = '".intval($team1)."',
									goals_team2 = '".intval($team2)."'
							WHERE	game = '".intval($uid)."'
							AND		fe_user_id = '".intval($GLOBALS["TSFE"]->fe_user->user['uid'])."'";

					$update=$GLOBALS['TYPO3_DB']->sql_query($sql) OR die(mysql_error().$sql);
					$i[] = $uid;
				}
			}
			else {
				$o[] = $uid;
			}
		}

		$content .= str_replace('###number###',count($i),$this->pi_getLL('successfullsavedbets')).'<br />';
		if (count($o)>0) $content .= str_replace('###number###',count($o),$this->pi_getLL('unsuccessfullfullsavedbets')).':<br />';

		t3lib_div::_GETset(array('mode' => t3lib_div::_POST('backmode'), 'group' => t3lib_div::_POST('backgroup')));

		$content .= $this->contentSwitch();
		return $content;
	}

	/**
	 * may the user bet on that game? (is it the right time?, is he logged in)
	 *
	 * @param	integer		$uid: id of the game
	 * @return	boolean		can he or not?
	 */
	function mayBetOnGame($uid) {
		if (!$this->loggedIn) {
			return false;
		}
		$sql = "SELECT		g.uid
				FROM		tx_worldcup_games g
				WHERE		g.deleted = 0
				AND			g.playtime > ".time()."
				AND			g.uid = ".intVal($uid)."
				LIMIT		1";
		$res=$GLOBALS['TYPO3_DB']->sql_query($sql) OR DIE(mysql_error());

		while ($r = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res)) {
			return true;
		}
		return false;
	}

	/**
	 * user ranking of all finished bets
	 *
	 * @return	string		output to website
	 */
	function ranking() {
		$sql = "SELECT	u.username,
						u.name,
						u.uid,

						SUM(CASE
									WHEN	g.goals_team2 IS NULL OR  g.goals_team1 IS NULL THEN 0
									WHEN	b.goals_team1 = g.goals_team1 AND b.goals_team2 = g.goals_team2	THEN 3
									".($this->pointsfordifference?"WHEN	b.goals_team1 - b.goals_team2 = g.goals_team1 - g.goals_team2 THEN 2":"")."
									WHEN	(CASE	WHEN b.goals_team1 > b.goals_team2 THEN 1
													WHEN b.goals_team1 < b.goals_team2 THEN 2
													ELSE 0
													END) =
											(CASE	WHEN g.goals_team1 > g.goals_team2 THEN 1
													WHEN g.goals_team1 < g.goals_team2 THEN 2
													ELSE 0 END)	THEN 1
								ELSE 0
						END) AS points

				FROM	(tx_worldcup_bets b INNER JOIN fe_users u
				ON		b.fe_user_id = u.uid
				AND		u.deleted = 0
				AND		b.deleted = 0
				AND		b.goals_team1 <> ''
				AND		b.goals_team2 <> '') LEFT OUTER JOIN tx_worldcup_games g
				ON		b.game = g.uid
				AND		g.deleted = 0
				AND		g.playtime < ".time()."
				AND		g.goals_team1 <> ''
				AND		g.goals_team2 <> ''
				GROUP	BY	u.username,
							u.name,
							u.uid
				ORDER	BY	points DESC";
		$res=$GLOBALS['TYPO3_DB']->sql_query($sql) OR DIE(mysql_error());
		$content .= '<h1>'.$this->pi_getLL('ranking').'</h1>';

		if (mysql_num_rows($res)===0) {
			$content .= '<br />'.$this->pi_getLL('nobetsfinished');
		}
		else {
			$content .= '<table>';
			$content .= '<tr>
							<td><strong>'.$this->pi_getLL('position').'</strong></td>
							<td><strong>'.$this->pi_getLL('player').'</strong></td>
							<td><strong>'.$this->pi_getLL('points').'</strong></td>
						</tr>';
			$i = 1;
			while ($r = $GLOBALS['TYPO3_DB']->sql_fetch_assoc($res)) {
				$content .= '<tr>
								<td align="center">'.$i.'</td>
								<td><acronym'.($this->loggedIn && $GLOBALS["TSFE"]->fe_user->user['uid'] == $r['uid']?' style="font-weight:bold"':'').' title="'.$r['name'].'">'.$r['username'].'</acronym></td>
								<td>'.$r['points'].'</td>
							</tr>';
				$i++;
			}
			$content .= '</table>';
		}
		return $content;
	}

	/**
	 * displays a standing of a group, how all users together rated them
	 *
	 * @param	string		$group: which group? (keychar)
	 * @param	integer		$userfilter: if set, show only bets from this user
	 * @return	string		output to website
	 */
	function howUserRanked ($group,$userfilter='') {
		if (!is_numeric($group)) {
			$sql = "SELECT	g.uid,
							g.playtime,
							g.team1 AS team1_uid,
							g.team2 AS team2_uid,
							b.goals_team1,
							b.goals_team2,
							g.place,
							g.finals,

							t1.name AS team1,
							t2.name AS team2,
							UPPER(t1.shortcut) AS shortcut1,
							UPPER(t2.shortcut) AS shortcut2

				FROM		((tx_worldcup_games g INNER JOIN  tx_worldcup_teams t1
				ON			g.team1 = t1.uid) INNER JOIN tx_worldcup_teams t2
				ON			g.team2 = t2.uid) LEFT OUTER JOIN tx_worldcup_bets b
				ON			g.uid = b.game
				AND			b.deleted = 0
				WHERE		g.deleted = 0
				AND			t1.deleted = 0
				AND			t2.deleted = 0
				AND			g.finals = '".$GLOBALS['TYPO3_DB']->quoteStr($group,'tx_worldcup_games')."'
				".(is_numeric($userfilter)?"AND	b.fe_user_id = '".intval($userfilter)."'":'');
			$res=$GLOBALS['TYPO3_DB']->sql_query($sql) OR $content .= $sql;

			if (mysql_num_rows($res)>0) $content .= $this->displayFullTable($this->calculateTable(&$res));
		}
		return $content;
	}
}

if (defined('TYPO3_MODE') && $TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/worldcup/pi1/class.tx_worldcup_pi1.php'])	{
	include_once($TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/worldcup/pi1/class.tx_worldcup_pi1.php']);
}

?>