<?php
/***************************************************************
*  Copyright notice
*
*  (c) 2006 Michael Fritz <michael.fritz@target-e.de>
*  All rights reserved
*
*  This script is part of the TYPO3 project. The TYPO3 project is
*  free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  The GNU General Public License can be found at
*  http://www.gnu.org/copyleft/gpl.html.
*
*  This script is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  This copyright notice MUST APPEAR in all copies of the script!
***************************************************************/
/**
 * Handles multidimentional array sorting by a key (not recursive)
 *
 * @author Oliwier Ptak <aleczapka at gmx dot net>
 * @package TYPO3
 * @subpackage worldcup
*/

class tx_worldcup_arraysorter {
	var $skey = false;
	var $sarray = false;
	var $sasc = true;

	/**
	* Constructor
	*
	* @access public
	* @param mixed $array array to sort
	* @param string $key array key to sort by
	* @param boolean $asc sort order (ascending or descending)
	*/
	function array_sorter(&$array, $key, $asc=true) {
		$this->sarray = $array;
		$this->skey = $key;
		$this->sasc = $asc;
	}

	/**
	* Sort method
	*
	* @access public
	* @param boolean $remap if true reindex the array to rewrite indexes
	*/
	function sortit($remap=true) {
		$array = &$this->sarray;
		uksort($array, array($this, "_as_cmp"));
		if ($remap)
		{
			 $tmp = array();
			 while (list($id, $data) = each($array))
					$tmp[] = $data;
			 return $tmp;
		}
		return $array;
	}

	/**
	* Custom sort function
	*
	* @access private
	* @param mixed $a an array entry
	* @param mixed $b an array entry
	*/
	function _as_cmp($a, $b) {
		//since uksort will pass here only indexes get real values from our array
		if (!is_array($a) && !is_array($b)) {
			 $a = $this->sarray[$a][$this->skey];
			 $b = $this->sarray[$b][$this->skey];
		}

		//if string - use string comparision
		if (!ctype_digit($a) && !ctype_digit($b)) {
			 if ($this->sasc)
					return strcasecmp($a, $b);
			 else
					return strcasecmp($b, $a);
		}
		else {
			 if (intval($a) == intval($b))
					return 0;

			 if ($this->sasc)
					return (intval($a) > intval($b)) ? -1 : 1;
			 else
					return (intval($a) > intval($b)) ? 1 : -1;
		}
	}
}

if (defined('TYPO3_MODE') && $TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/worldcup/pi1/class.tx_worldcup_arraysorter.php'])	{
	include_once($TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/worldcup/pi1/class.tx_worldcup_arraysorter.php']);
}
?>